import sql from 'mssql';
import { config } from './config.js';

const deleteAuthorById = async (id) => {
  try {
    // Connect to the database
    const pool = await sql.connect(config);

    // Execute the query
    const result = await pool
      .request()
      .input('id', sql.Int, id)
      .query(`DELETE  FROM Authors WHERE AuthorID = @id`);

    if (result?.rowsAffected?.length >= 1) {
      console.log(`${result.rowsAffected.length} row(s) deleted!`);
    }
  } catch (err) {
    console.error(err);
  }
};

export { deleteAuthorById };
